@extends('layouts.app')
@section('title', __('repair::lang.repair') . ' '. __('business.dashboard'))
<meta name="csrf-token" content="{{ csrf_token() }}">

@section('content')
@include('repair::layouts.nav')
<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>
    	@lang('repair::lang.repair')
    	<small>@lang('business.dashboard')</small>
    </h1>
</section>
<!-- Main content -->
<section class="content no-print">
	<div class="row">
		<div class="col-md-12">

			<div class="box box-solid">
				<div class="raw">
					<div class="col-md-9">
						<div class="box-header with-border">
							<h4 class="box-title">@lang('repair::lang.job_sheets_by_status')</h4>
						</div>
					</div>
					<div class="col-md-3">
						<div class="form-group">
							{!! Form::label('ssr_date_range', __('report.date_range') . ':') !!}
							{!! Form::text('date_range', @format_date('first day of this month') . ' ~ ' . @format_date('last day of this month'), ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'ssr_date_range', 'readonly']); !!}
						</div>
					</div>

				</div>

				<div class="box-body">
					<div class="row">
				        @forelse($job_sheets_by_status as $job_sheet)
							<div class="col-md-3 col-sm-6 col-xs-12">
								<div class="small-box" style="background-color: {{$job_sheet->color}};color: #fff;">
						            <div class="inner">
						              	<p>{{$job_sheet->status_name}}</p>
						              	<h3 id="JobSheetId-{{$job_sheet->status_id}}" class="JobSheetStatusBe">{{$job_sheet->total_job_sheets}}</h3>
						            </div>
					          	</div>
					        </div>
					    @empty
					    	<div class="col-md-12">
	    						<div class="alert alert-info">
					                <h4>@lang('repair::lang.no_report_found')</h4>
					            </div>
				           	</div>
						@endforelse
					</div>
				</div>
			</div>
		</div>
	</div>
	@if(in_array('service_staff', $enabled_modules))
		<div class="row">
		    <div class="col-xs-12">
		        @component('components.widget')
		            @slot('title')
		                @lang('repair::lang.job_sheets_by_service_staff')
		            @endslot
		            <div class="table-responsive">
						<table class="table table-striped">
							<thead>
								<tr>
									<th>#</th>
									<th>@lang('restaurant.service_staff')</th>
									<th>@lang('repair::lang.total_job_sheets')</th>
								</tr>
							</thead>
							<tbody>
								@foreach($job_sheets_by_service_staff as $job_sheet)
									<tr>
										<td>{{$loop->iteration}}</td>
										<td>{{$job_sheet->service_staff}}</td>
										<td id="jobTotal-{{$job_sheet->stuffId}}" class="jobSheetTotalStaff">{{$job_sheet->total_job_sheets}}</td>
									</tr>
								@endforeach
							</tbody>
						</table>
					</div>
		        @endcomponent
		    </div>
		</div>
	@endif
	<div class="row">
	    <div class="col-xs-12">
	        @component('components.widget')
	            @slot('title')
	                @lang('repair::lang.trending_brands')
	            @endslot
	            {!!$trending_brand_chart->container()!!}
	        @endcomponent
	    </div>
	</div>
	<div class="row">
	    <div class="col-xs-12">
	        @component('components.widget')
	            @slot('title')
	                @lang('repair::lang.trending_devices')
	            @endslot
	            {!!$trending_devices_chart->container()!!}
	        @endcomponent
	    </div>
	</div>
	<div class="row">
	    <div class="col-xs-12">
	        @component('components.widget')
	            @slot('title')
	                @lang('repair::lang.trending_device_models')
	            @endslot
	            {!!$trending_dm_chart->container()!!}
	        @endcomponent
	    </div>
	</div>
</section>
@stop
@section('javascript')
	{!!$trending_devices_chart->script()!!}
	{!!$trending_dm_chart->script()!!}
	{!!$trending_brand_chart->script()!!}
	<script type="text/javascript">
		$(document).ready(function () {
			if ($('#ssr_date_range').length == 1) {
				$('#ssr_date_range').daterangepicker({
					ranges: ranges,
					autoUpdateInput: false,
					startDate: moment().startOf('month'),
					endDate: moment().endOf('month'),
					locale: {
						format: moment_date_format
					}
				});
				$('#ssr_date_range').on('apply.daterangepicker', function (ev, picker) {
					$(this).val(picker.startDate.format(moment_date_format) + ' ~ ' + picker.endDate.format(moment_date_format));
					CallDate();

				});

				$('#ssr_date_range').on('cancel.daterangepicker', function (ev, picker) {
					$(this).val('');
					pending_job_sheets_datatable.ajax.reload();
					completed_job_sheets_datatable.ajax.reload();
				});
			}
		})
		function CallDate() {
			$(".jobSheetTotalStaff").each(function() {
				$(this).text("0");
			});
			$(".JobSheetStatusBe").each(function() {
				$(this).text("0");
			});
			var start_date;
			var end_date;
			if($('#ssr_date_range').val()) {
				var start = $('#ssr_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
				var end = $('#ssr_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
				start_date = start;
				end_date = end;
			}
			else {
				start_date = '2020-01-01';
				end_date = '2099-01-01';
			}
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}

			});
			$.ajax({
				type: "GET",
				url: '/repair/orderdata',
				dataType: 'json',// This is what I have updated
				data:  {
					start_date,
							end_date

				},
				success: function (result) {
					//alert(result);
					//var data = JSON.parse(result);
					console.log(result);
					for (var x = 0; x < result.length; x++) {
						content = result[x].total_job_sheets;
						content += "<br>";
						content += result[x].status_name;
						content += "<br>";
						//alert(content);
						$('#JobSheetId-'+result[x].status_id).text(result[x].total_job_sheets);
						// updateListing(data[x]);
					}

				}
			});
			CallDate2();
		}


		function CallDate2() {
			var start_date;
			var end_date;
			if($('#ssr_date_range').val()) {
				var start = $('#ssr_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
				var end = $('#ssr_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
				start_date = start;
				end_date = end;
			}
			else {
				start_date = '2020-01-01';
				end_date = '2099-01-01';
			}
			$.ajaxSetup({
				headers: {
					'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
				}

			});
			$.ajax({
				type: "GET",
				url: '/repair/orderdata2',
				dataType: 'json',// This is what I have updated
				data:  {
					start_date,
					end_date

				},
				success: function (result) {
					//alert(result);
					//var data = JSON.parse(result);
					console.log(start_date);
					console.log(end_date);
					console.log(result);

					var counter=1;
					for (var x = 0; x < result.length; x++) {

						//alert(content);
						$('#jobTotal-'+result[x].stuffId).text(result[x].total_job_sheets);
						counter++;
						// updateListing(data[x]);
					}

				}
			});
		}
	</script>
@endsection