@extends('repair::layouts.repair_status')
@section('title', __('repair::lang.repair_status'))
@section('content')
<div class="login-form col-md-12 col-xs-12 right-col-content">
    <p class="form-header text-white">{{__('repair::lang.repair_status')}}</p>
    <form method="POST" action="{{action('\Modules\Repair\Http\Controllers\CustomerRepairStatusController@postRepairStatus')}}" id="check_repair_status">
        <div class="form-group">
    		<div class="multi-input">
		    	{!! Form::select('search_type', 
		      	['job_sheet_no' => __('repair::lang.job_sheet_no'), 
		      	'invoice_no' => __('sale.invoice_no')], 
		      	null, 
		      	['class' => 'form-control width-60 pull-left']); !!}

		    	{!! Form::text('search_number', null, ['class' => 'form-control width-40 pull-left', 'required', 'placeholder' => __('repair::lang.job_sheet_or_invoice_no')]); !!}
		    </div>
        </div><br><br>
        <div class="form-group">
    		<div class="input-group">
    			<div class="input-group-addon"><i class="fas fa-microchip"></i></div>
            	<input type="text" name="serial_no" class="form-control" id="repair_serial_no" placeholder="@lang('repair::lang.serial_no')">
    		</div>
        </div>
        <div class="form-group">
	        <button type="submit" class="btn-login btn btn-primary btn-flat ladda-button">
	        	@lang('lang_v1.search')
	       	</button>
	    </div>
   </form>
</div>
<div class="col-md-12 col-xs-12">
 	<div class="row repair_status_details">
		<div class="col-md-12">
			<div class="box box-solid">
				<div class="box-header with-border">
					<h2 class="box-title">
						<i class="fas fa-receipt"></i>
						{{ $sell->job_sheet_no }}
					</h2>
				</div>
				<div class="box-body">
					<div class="row">
						<div class="col-md-6">
							<strong>@lang('product.brand'): </strong> {{$sell->manufacturer}}
						</div>
						<div class="col-md-6">
							<strong>@lang('repair::lang.device'): </strong> {{$sell->repair_device}}
						</div>
					</div>
					<div class="row mt-10">
						<div class="col-md-6">
							<strong>@lang('repair::lang.model'): </strong> {{$sell->repair_model}}
						</div>
						<div class="col-md-6">
							<strong>
								@lang('repair::lang.serial_no'):
							</strong> {{$sell->serial_no}}
						</div>
					</div>
					<div class="row mt-10">
						<div class="col-md-6">
							<strong>
								{{ __('repair::lang.current_repair_status') }}:
							</strong>
							<span class="label" style="background-color: {{$sell->repair_status_color}};">
						{{$sell->repair_status}}
					</span>
						</div>
						<div class="col-md-6">
							<strong>
								{{ __('repair::lang.expected_delivery_date') }}:
							</strong>
							@if(!empty($sell->delivery_date))
								{{\Carbon::parse($sell->delivery_date)->toDayDateTimeString()}}
							@endif
						</div>
					</div>
					<div class="row mt-10">
						<div class="col-md-12 col-xs-12">
							<strong>
								<span>{{ __('repair::lang.activities') }}:</span>
							</strong>
							@includeIf('repair::customer_repair.repair_activities')
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection
@section('javascript')
<script type="text/javascript">
	$(document).ready(function(){
		$(document).on('submit', 'form#check_repair_status', function(e) {
	        e.preventDefault();
		    var data = $('form#check_repair_status').serialize();
		    var url = $('form#check_repair_status').attr('action');
		    var ladda = Ladda.create(document.querySelector('.ladda-button'));
	    	ladda.start();
		    $.ajax({
		        method: 'POST',
		        url: url,
		        dataType: 'json',
		        data: data,
		        success: function(result) {
		        	ladda.stop();
		            if (result.success) {
		            	$(".repair_status_details").html(result.repair_html);
		                toastr.success(result.msg);
		            } else {
		                toastr.error(result.msg);
		            }
		        }
		    });
	   	});
	});
</script>
@endsection